/*
 * Decompiled with CFR 0.152.
 */
package org.cloudwarp.mobscarecrow.utils;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.util.LinkedList;
import java.util.Map;
import java.util.Scanner;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_3222;
import org.apache.logging.log4j.Logger;
import org.cloudwarp.mobscarecrow.MobScarecrow;

public class Config {
    private static final String CONFIG_FILE = "config/mobscarecrows.json";
    private static Config instance = null;
    private final Logger LOGGER = MobScarecrow.LOGGER;
    public class_2487 configData;
    private int difference = 0;

    private Config() {
    }

    public static Config getInstance() {
        if (instance == null) {
            instance = new Config();
        }
        return instance;
    }

    public static JsonObject getJsonObject(String json) {
        return JsonParser.parseString((String)json).getAsJsonObject();
    }

    public static String readFile(File file) throws FileNotFoundException {
        Scanner scanner = new Scanner(file);
        scanner.useDelimiter("\\Z");
        String result = scanner.next();
        scanner.close();
        return result;
    }

    public double getScarerowDistance() {
        return this.configData.method_10574("scarecrow_distance");
    }

    public int getIntOrDefault(class_2487 getFrom, String key, class_2487 defaults) {
        if (getFrom.method_10545(key)) {
            return getFrom.method_10550(key);
        }
        ++this.difference;
        return defaults.method_10550(key);
    }

    public boolean getBooleanOrDefault(class_2487 getFrom, String key, class_2487 defaults) {
        if (getFrom.method_10545(key)) {
            return getFrom.method_10577(key);
        }
        ++this.difference;
        return defaults.method_10577(key);
    }

    private String getStringOrDefault(class_2487 getFrom, String key, class_2487 defaults) {
        if (getFrom.method_10545(key)) {
            return getFrom.method_10558(key);
        }
        ++this.difference;
        return defaults.method_10558(key);
    }

    private class_2487 getCompoundOrDefault(class_2487 getFrom, String key, class_2487 defaults) {
        if (getFrom.method_10545(key)) {
            return getFrom.method_10562(key);
        }
        ++this.difference;
        return defaults.method_10562(key);
    }

    private double getDoubleOrDefault(class_2487 getFrom, String key, class_2487 defaults) {
        if (getFrom.method_10545(key)) {
            return getFrom.method_10574(key);
        }
        ++this.difference;
        return defaults.method_10574(key);
    }

    private float getFloatOrDefault(class_2487 getFrom, String key, class_2487 defaults) {
        if (getFrom.method_10545(key)) {
            return getFrom.method_10583(key);
        }
        ++this.difference;
        return defaults.method_10583(key);
    }

    public int getIntOrDefault(JsonObject getFrom, String key, class_2487 defaults) {
        if (getFrom.has(key)) {
            return getFrom.get(key).getAsInt();
        }
        ++this.difference;
        return defaults.method_10550(key);
    }

    public boolean getBooleanOrDefault(JsonObject getFrom, String key, class_2487 defaults) {
        if (getFrom.has(key)) {
            return getFrom.get(key).getAsBoolean();
        }
        ++this.difference;
        return defaults.method_10577(key);
    }

    private String getStringOrDefault(JsonObject getFrom, String key, class_2487 defaults) {
        if (getFrom.has(key)) {
            return getFrom.get(key).getAsString();
        }
        ++this.difference;
        return defaults.method_10558(key);
    }

    private double getDoubleOrDefault(JsonObject getFrom, String key, class_2487 defaults) {
        if (getFrom.has(key)) {
            return getFrom.get(key).getAsDouble();
        }
        ++this.difference;
        return defaults.method_10574(key);
    }

    private float getFloatOrDefault(JsonObject getFrom, String key, class_2487 defaults) {
        if (getFrom.has(key)) {
            return getFrom.get(key).getAsFloat();
        }
        ++this.difference;
        return defaults.method_10583(key);
    }

    private class_2487 getDefaults() {
        class_2487 defaultConfig = new class_2487();
        defaultConfig.method_10549("scarecrow_distance", 8.0);
        return defaultConfig;
    }

    private JsonObject toJson(class_2487 tag) {
        JsonObject json = new JsonObject();
        class_2487 defaults = this.getDefaults();
        json.addProperty("scarecrow_distance", (Number)this.getDoubleOrDefault(tag, "scarecrow_distance", defaults));
        this.createFile(json, this.difference > 0);
        this.difference = 0;
        return json;
    }

    private class_2487 toNbtCompound(JsonObject json) {
        class_2487 tag = new class_2487();
        class_2487 defaults = this.getDefaults();
        tag.method_10549("scarecrow_distance", this.getDoubleOrDefault(json, "scarecrow_distance", defaults));
        this.createFile(this.toJson(tag), this.difference > 0);
        this.difference = 0;
        return tag;
    }

    public boolean loadConfig() {
        try {
            return this.loadConfig(Config.getJsonObject(Config.readFile(new File(CONFIG_FILE))));
        }
        catch (Exception e) {
            this.LOGGER.info("Found error with config. Using default config.");
            this.configData = this.getDefaults();
            this.createFile(this.toJson(this.configData), true);
            return false;
        }
    }

    private boolean loadConfig(JsonObject fileConfig) {
        try {
            this.configData = this.toNbtCompound(fileConfig);
            return true;
        }
        catch (Exception e) {
            this.LOGGER.info("Found error with config. Using default config.");
            this.configData = this.getDefaults();
            this.createFile(this.toJson(this.configData), true);
            return false;
        }
    }

    public boolean loadConfig(class_2487 config) {
        try {
            this.configData = config;
            return true;
        }
        catch (Exception e) {
            this.LOGGER.info("Found error with config. Using default config.");
            this.configData = this.getDefaults();
            this.createFile(this.toJson(this.configData), true);
            return false;
        }
    }

    private void createFile(JsonObject contents, boolean overwrite) {
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        contents = JsonParser.parseString((String)gson.toJson((JsonElement)contents)).getAsJsonObject();
        File file = new File(CONFIG_FILE);
        if (file.exists() && !overwrite) {
            return;
        }
        file.getParentFile().mkdirs();
        try {
            file.createNewFile();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        file.setReadable(true);
        file.setWritable(true);
        if (contents == null) {
            return;
        }
        try (FileWriter writer = new FileWriter(file);){
            String json = gson.toJson((JsonElement)contents).replace("\n", "").replace("\r", "");
            writer.write(gson.toJson((JsonElement)JsonParser.parseString((String)json).getAsJsonObject()));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void print(class_3222 player) {
        LinkedList<JsonObject> q = new LinkedList<JsonObject>();
        q.add(this.toJson(this.configData));
        while (!q.isEmpty()) {
            JsonObject current = (JsonObject)q.poll();
            for (Map.Entry entry : current.entrySet()) {
                String key = (String)entry.getKey();
                JsonElement value = (JsonElement)entry.getValue();
                if (value.isJsonObject()) {
                    q.add(value.getAsJsonObject());
                    continue;
                }
                player.method_7353((class_2561)new class_2585("\u00a76[\u00a7e" + key + "\u00a76] \u00a73 " + value), false);
            }
        }
    }
}

